VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MyErrObjectClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Type ErrorQueue
  description_ As String
  number_ As Long
  source_ As String
  lastDllError_ As Long
  date_ As Variant
  time_ As Variant
  notes As String
End Type

Const BUFFER_SIZE = 100

Private mErrorBuffer(BUFFER_SIZE) As ErrorQueue
Private mErrorsSinceStart As Long

Private mDescription As String
Private mHelpContext As Long
Private mHelpFile As String
Private mLastDllError As Long
Private mNumber As Long
Private mSource As String

Private Sub Class_Initialize()

  On Error GoTo oops:
  
  Clear
  mSource = "SciFish2000"
  mErrorsSinceStart = 0
  
  Exit Sub
oops:
  ' fail silently
  Debug.Assert (False)
  
End Sub

Public Sub Raise(Optional eNumber As Variant, Optional eSource As Variant, _
                Optional eDescription As Variant, Optional eHelpFile As Variant, _
                Optional eHelpContext As Variant)
  
  On Error GoTo oops:
  
  If IsMissing(eNumber) Then eNumber = mNumber
  If IsMissing(eSource) Then eSource = mSource
  If IsMissing(eDescription) Then eDescription = mDescription
  If IsMissing(eHelpFile) Then eHelpFile = mHelpFile
  If IsMissing(eHelpContext) Then eHelpContext = mHelpContext
  
  On Error GoTo 0
  Err.Raise eNumber, eSource, eDescription, eHelpFile, eHelpContext
  
  Exit Sub
oops:
  ' fail silently
  Debug.Assert (False)
  
End Sub

Public Sub Clear()
  
  On Error GoTo oops:
  mNumber = 0
  mSource = ""
  mDescription = ""
  mHelpFile = ""
  mHelpContext = 0
  mLastDllError = 0

  Exit Sub
oops:
  ' fail silently
  Debug.Assert (False)

End Sub

Public Sub Store(Optional eNumber As Variant, Optional eSource As Variant, _
                Optional eDescription As Variant, Optional eHelpFile As Variant, _
                Optional eHelpContext As Variant, Optional eLastDllError As Variant)
  
  If IsMissing(eNumber) Then eNumber = Err.number
  If IsMissing(eSource) Then eSource = Err.Source
  If IsMissing(eDescription) Then eDescription = Err.description
  If IsMissing(eHelpFile) Then eHelpFile = Err.helpFile
  If IsMissing(eHelpContext) Then eHelpContext = Err.HelpContext
  If IsMissing(eLastDllError) Then eLastDllError = Err.lastDllError
  
  On Error GoTo oops:
  
  mNumber = eNumber
  mSource = eSource
  mDescription = eDescription
  mHelpFile = eHelpFile
  mHelpContext = eHelpContext
  mLastDllError = eLastDllError
  
  ' EnQueueError - Not tested yet.  Could be very useful for customer support and _
                   for graceful handling of complex errors.

  Exit Sub
oops:
  ' fail silently
  Debug.Assert (False)
  
End Sub

Public Property Get number() As Variant
  number = mNumber
End Property

Public Property Let number(ByVal vNewValue As Variant)
  mNumber = vNewValue
End Property

Public Property Get Source() As Variant
  Source = mSource
End Property

Public Property Let Source(ByVal vNewValue As Variant)
  mSource = vNewValue
End Property

Public Property Get description() As Variant
  description = mDescription
End Property

Public Property Let description(ByVal vNewValue As Variant)
  mDescription = vNewValue
End Property

Public Property Get helpFile() As Variant
  helpFile = mHelpFile
End Property

Public Property Let helpFile(ByVal vNewValue As Variant)
  mHelpFile = vNewValue
End Property

Public Property Get HelpContext() As Variant
  HelpContext = mHelpContext
End Property

Public Property Let HelpContext(ByVal vNewValue As Variant)
  mHelpContext = vNewValue
End Property

Public Property Get lastDllError() As Variant
  lastDllError = mLastDllError
End Property

Public Property Let lastDllError(ByVal vNewValue As Variant)
  mLastDllError = vNewValue
End Property

Private Sub EnQueueError()

  On Error GoTo oops:
  
  Dim position As Long
  
  position = mErrorsSinceStart Mod BUFFER_SIZE
  
  With mErrorBuffer(position)
    .description_ = mDescription
    .number_ = mNumber
    .source_ = mSource
    .lastDllError_ = mLastDllError
    .date_ = Date
    .time_ = Time
    .notes = "not yet used"
  End With

Exit Sub
oops:
  ' fail silently
  Debug.Assert (False)
  
End Sub

Private Sub CreateBugReport()

  ' stub
  ' Should gather all system data, version numbers, settings, and file locations.
  ' The user should be encouraged to enter notes...
  ' The user should be given a choose of formats - e.g. ASCII, RTF, Word??, HTML???
  ' The bug report should then be generated automatically.
  
End Sub

Private Sub LogErrors()

  ' stub
  ' attempts to write to DB first.
  ' if it can't write to the DB it then dumps to a txt file.
  ' Serious errors are logged to NT's event log.
  
End Sub

Private Sub WriteErrorsToTextFile()

  ' stub
  
End Sub

Private Sub WriteErrorsToDB()

  ' stub
  '
  
End Sub

Private Sub ViewErrorLog()

  ' stub
  
End Sub

Public Sub ErrBox()

  ' stub
  ' Calls an improved error box form that would allow the user to cut/paste
  ' error messages, create a bugreport, etc.
  
End Sub

Public Function IsClear()

  On Error GoTo oops:
  
  IsClear = (mNumber = 0)
  
  Exit Function
oops:
  ' fail silently
  Debug.Assert (False)
  IsClear = False
  
End Function

Public Function DescriptionOfError(number As ErrorValueEnum) As String

  On Error GoTo oops:
  DescriptionOfError = "No despcription fo the error is available for error #" & Str(number)
  Select Case number
    Case Is < 1000, Is > 30000
      ' these are VB errors
      DescriptionOfError = Error(number)
      
    Case Is < 2000
      ' vb errors that have been raised
      DescriptionOfError = Error(number - 1000)
      
    Case UNKNOWN_ERROR
          DescriptionOfError = "An unknown error occured. (Sorry)"
      ' DB errors
    Case DELETE_ERROR
    Case LOAD_ERROR
          DescriptionOfError = "Unable to load the chosen profile" & vbCrLf _
                  & "There may be a problem with the parameter database. (Sorry)"
    Case SAVE_ERROR
    
      ' File Errors
    
      ' Initialization Errors
     
      ' misc
    
    Case APPLY_ERROR
    Case BADALGORITHM_ERROR
      DescriptionOfError = "The current software does not recognise" & vbCrLf _
                  & "the specified algorithm, sorry..."
    Case CLOSE_ERROR
    Case CTRLCONFIG_ERROR
    Case FORMREAD_ERROR
    Case NUMPARAM_ERROR
    Case PROPERTYLIST_ERROR
      DescriptionOfError = "Can not read/write to the property list in the" & vbCrLf & _
                    "parameter database file. (Sorry)"
    Case SETCONFIGTYPE_ERROR
      DescriptionOfError = "SetValue method of the general configuration class failed" & " (Oops!)"
    Case VALUE_NOT_SET_ERROR
    Case Else
      DescriptionOfError = "No error descriptionoferror available"
  End Select
  
  Exit Function
  
oops:
  ' fail silently
  Debug.Assert (False)
  DescriptionOfError = "Can't find error description.  (Sorry.)"
  
End Function



